//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;

namespace LOC
{
	/// <summary>
	/// Podsumowanie dla Class1.
	/// </summary>
	class LargeObjectTest
	{
		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			GC.Collect();
			Console.WriteLine("Cakowita liczba bajtw przed alokacj: {0}", GC.GetTotalMemory(false));
			LargeObject lo = new LargeObject();
			Console.WriteLine("Cakowita liczba bajtw: {0}", GC.GetTotalMemory(false));
			Console.WriteLine("Obiekt generacji {0}", GC.GetGeneration(lo));
			Console.WriteLine("Oczyszczanie");
			GC.Collect();
			Console.WriteLine("Cakowita liczba bajtw po oczyszczaniu: {0}", GC.GetTotalMemory(false));
			Console.WriteLine("Obiekt generacji {0}", GC.GetGeneration(lo));
			Console.WriteLine("Dealokacja obiektu");
			lo = null;
			Console.WriteLine("Oczyszczanie");
			GC.Collect();
			Console.WriteLine("Cakowita liczba bajtw po oczyszczaniu: {0}", GC.GetTotalMemory(false));
			Console.WriteLine("Oczyszczanie");
			GC.Collect();
			Console.WriteLine("Cakowita liczba bajtw po oczyszczaniu: {0}", GC.GetTotalMemory(false));

			Console.WriteLine("----------- Ponownie -----------");

			Console.WriteLine("Cakowita liczba bajtw przed alokacj: {0}", GC.GetTotalMemory(false));
			LargeObject lo = new LargeObject();
			Console.WriteLine("Cakowita liczba bajtw: {0}", GC.GetTotalMemory(false));
			Console.WriteLine("Obiekt generacji {0}", GC.GetGeneration(lo));
			Console.WriteLine("Oczyszczanie");
			GC.Collect();
			Console.WriteLine("Cakowita liczba bajtw po oczyszczaniu: {0}", GC.GetTotalMemory(false));
			Console.WriteLine("Obiekt generacji {0}", GC.GetGeneration(lo));
			Console.WriteLine("Dealokacja obiektu");
			lo = null;
			Console.WriteLine("Oczyszczanie");
			GC.Collect();
			Console.WriteLine("Cakowita liczba bajtw po oczyszczaniu: {0}", GC.GetTotalMemory(false));
			Console.WriteLine("Oczyszczanie");
			GC.Collect();
			Console.WriteLine("Cakowita liczba bajtw po oczyszczaniu: {0}", GC.GetTotalMemory(false));
		}
	}
}
